define(['app', 'angular'], function (app, angular) {
	app.directive('entryForm', function ($timeout, $q, focusService, modalService) {
		return {
			restrict: 'AE',
			transclude: true,
			scope : {
				name: "@",
				service: "=",
				callbacks: "=",
				ngModel: "=",
				actionsAllowed : "=",
				hideButtons: "=?",
				errorValidators: "=?",
				hideRequiredMessage: "@"
			},
			link: function (scope, element) {
				var formCtrl = element.find("form:first").controller("form");

				if(scope.name) {
					formCtrl.$name = scope.name;
					scope.$parent[scope.name] = formCtrl;
				}

				function callback(type){
					if(scope.callbacks) {
						if(scope.callbacks.common) {
							scope.callbacks.common(scope.ngModel);
						}
						if(scope.callbacks[type]) { 
							scope.callbacks[type](scope.ngModel);
						}
					}
				}

				scope.isEditable = true;

				scope.$watch("ngModel", function(newVal, oldVal) {
					if(newVal !== oldVal) {
						formCtrl.validationSummary.clear();
					}
				});

				scope.requiredExists = function(){
					return element.find(":input[required]").length > 0;
				};

				scope.save = function() {
					formCtrl.validationSummary.validate().then(function () {
						if (scope.callbacks.allowSave) {
							scope.callbacks.allowSave().then(function () {
								makeRequest("save");
							});
						} else {
							makeRequest("save");
						}
					});
				};

				scope.delete = function(){
					var modalOptions = {
						closeButtonText: 'No',
						actionButtonText: 'Yes',
						headerText: 'Confirmation',
						bodyText: 'Are you sure you want to remove this entry? Select YES to remove the entry or NO to return to the entry screen.'
					};

					modalService.showModal({}, modalOptions).then(function () {
						makeRequest("delete");
					}, function () {
		                focusService.focusElement(element.find('button[ng-click="delete()"]:last'));
					});
				};

				scope.cancel = function(){
					formCtrl.$setPristine();
					callback("cancel");
				};

				function makeRequest(type) {
					scope.isEditable = false;
					var requestPromise = scope.service[type](scope.ngModel).then(function () {
						formCtrl.$setPristine();
						callback(type);
					}, function (error) {
						return $q.reject(error);
					}).finally(function(){
						scope.isEditable = true;
					});
					formCtrl.validationSummary.summarizeAsync([requestPromise]);
				}

				formCtrl.entryFormActions = {
					save : scope.save,
					delete : scope.delete,
					cancel : scope.cancel
				};
			},
			templateUrl: 'src/ui-components/form/entry-form/entry-form_template.html'
		};
	});
});